function d = hausdorff(C1,C2)

% Computes the Hausdorff distance (actually its upper bound)
% between two convex sets represented by their verticies. 
% 
% Input format: C1=[x_1;...;x_m], where x_i is the i-th extreme
% point of set C1.  Similarly for C2. 

N1 = size(C1,1);
N2 = size(C2,1);

for i=1:N1; for j=1:N2
    
    dist(i,j) = max(abs(C1(i,:)-C2(j,:))); % dist b/w ext pts
    
end; end

d = max([max(min(dist,[],1)),max(min(dist,[],2))]);
